
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    SubClassValueT as _SubClassValueT,
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "tensor"
  pass


@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def bitcast(dest, source, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(BitcastOp(dest=dest, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CastOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def cast(dest, source, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(CastOp(dest=dest, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CollapseShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.collapse_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, reassociation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["reassociation"] = (reassociation if (
    issubclass(type(reassociation), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexListArrayAttr')) else
      _ods_ir.AttrBuilder.get('IndexListArrayAttr')(reassociation, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def reassociation(self):
    return self.operation.attributes["reassociation"]

  @reassociation.setter
  def reassociation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reassociation"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def collapse_shape(result, src, reassociation, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(CollapseShapeOp(result=result, src=src, reassociation=reassociation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConcatOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.concat"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, dim, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    issubclass(type(dim), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dim, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dim(self):
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def concat(result, dim, inputs, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ConcatOp(result=result, dim=dim, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DimOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(index))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def dim(source, index, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DimOp(source=source, index=index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class EmptyOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.empty"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, dynamicSizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(dynamicSizes))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dynamicSizes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def empty(result, dynamic_sizes, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(EmptyOp(result=result, dynamicSizes=dynamic_sizes, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExpandShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.expand_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, reassociation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["reassociation"] = (reassociation if (
    issubclass(type(reassociation), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexListArrayAttr')) else
      _ods_ir.AttrBuilder.get('IndexListArrayAttr')(reassociation, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def reassociation(self):
    return self.operation.attributes["reassociation"]

  @reassociation.setter
  def reassociation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reassociation"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def expand_shape(result, src, reassociation, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ExpandShapeOp(result=result, src=src, reassociation=reassociation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def extract(tensor, indices, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ExtractOp(tensor=tensor, indices=indices, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExtractSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.extract_slice"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(offsets))
    operands.append(_get_op_results_or_values(sizes))
    operands.append(_get_op_results_or_values(strides))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_offsets"] = (static_offsets if (
    issubclass(type(static_offsets), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_offsets, context=_ods_context))
    attributes["static_sizes"] = (static_sizes if (
    issubclass(type(static_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_sizes, context=_ods_context))
    attributes["static_strides"] = (static_strides if (
    issubclass(type(static_strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_strides, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def offsets(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def sizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def strides(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def static_offsets(self):
    return self.operation.attributes["static_offsets"]

  @static_offsets.setter
  def static_offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_offsets"] = value

  @builtins.property
  def static_sizes(self):
    return self.operation.attributes["static_sizes"]

  @static_sizes.setter
  def static_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_sizes"] = value

  @builtins.property
  def static_strides(self):
    return self.operation.attributes["static_strides"]

  @static_strides.setter
  def static_strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_strides"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def extract_slice(result, source, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ExtractSliceOp(result=result, source=source, offsets=offsets, sizes=sizes, strides=strides, static_offsets=static_offsets, static_sizes=static_sizes, static_strides=static_strides, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FromElementsOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.from_elements"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, elements, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(elements))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def elements(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def from_elements(result, elements, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(FromElementsOp(result=result, elements=elements, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GatherOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, indices, gather_dims, *, unique=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["gather_dims"] = (gather_dims if (
    issubclass(type(gather_dims), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(gather_dims, context=_ods_context))
    if bool(unique): attributes["unique"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    return self.operation.operands[1]

  @builtins.property
  def gather_dims(self):
    return self.operation.attributes["gather_dims"]

  @gather_dims.setter
  def gather_dims(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["gather_dims"] = value

  @builtins.property
  def unique(self):
    return "unique" in self.operation.attributes

  @unique.setter
  def unique(self, value):
    if bool(value):
      self.operation.attributes["unique"] = _ods_ir.UnitAttr.get()
    elif "unique" in self.operation.attributes:
      del self.operation.attributes["unique"]

  @unique.deleter
  def unique(self):
    del self.operation.attributes["unique"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def gather(result, source, indices, gather_dims, *, unique=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(GatherOp(result=result, source=source, indices=indices, gather_dims=gather_dims, unique=unique, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GenerateOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.generate"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, dynamicExtents, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(dynamicExtents))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dynamicExtents(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

  @builtins.property
  def body(self):
    return self.regions[0]

def generate(result, dynamic_extents, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(GenerateOp(result=result, dynamicExtents=dynamic_extents, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InsertOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.insert"

  _ODS_REGIONS = (0, True)

  def __init__(self, scalar, dest, indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(scalar))
    operands.append(_get_op_result_or_value(dest))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def scalar(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def insert(scalar, dest, indices, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(InsertOp(scalar=scalar, dest=dest, indices=indices, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InsertSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.insert_slice"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_results_or_values(offsets))
    operands.append(_get_op_results_or_values(sizes))
    operands.append(_get_op_results_or_values(strides))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_offsets"] = (static_offsets if (
    issubclass(type(static_offsets), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_offsets, context=_ods_context))
    attributes["static_sizes"] = (static_sizes if (
    issubclass(type(static_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_sizes, context=_ods_context))
    attributes["static_strides"] = (static_strides if (
    issubclass(type(static_strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_strides, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def dest(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def offsets(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def sizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def strides(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def static_offsets(self):
    return self.operation.attributes["static_offsets"]

  @static_offsets.setter
  def static_offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_offsets"] = value

  @builtins.property
  def static_sizes(self):
    return self.operation.attributes["static_sizes"]

  @static_sizes.setter
  def static_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_sizes"] = value

  @builtins.property
  def static_strides(self):
    return self.operation.attributes["static_strides"]

  @static_strides.setter
  def static_strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_strides"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def insert_slice(source, dest, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(InsertSliceOp(source=source, dest=dest, offsets=offsets, sizes=sizes, strides=strides, static_offsets=static_offsets, static_sizes=static_sizes, static_strides=static_strides, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PackOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.pack"

  _ODS_OPERAND_SEGMENTS = [1,1,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, inner_dims_pos, inner_tiles, static_inner_tiles, *, padding_value=None, outer_dims_perm=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_result_or_value(padding_value) if padding_value is not None else None)
    operands.append(_get_op_results_or_values(inner_tiles))
    _ods_context = _ods_get_default_loc_context(loc)
    if outer_dims_perm is not None: attributes["outer_dims_perm"] = (outer_dims_perm if (
        issubclass(type(outer_dims_perm), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(outer_dims_perm, context=_ods_context))
    attributes["inner_dims_pos"] = (inner_dims_pos if (
    issubclass(type(inner_dims_pos), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(inner_dims_pos, context=_ods_context))
    attributes["static_inner_tiles"] = (static_inner_tiles if (
    issubclass(type(static_inner_tiles), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_inner_tiles, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def dest(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def padding_value(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def inner_tiles(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def outer_dims_perm(self):
    if "outer_dims_perm" not in self.operation.attributes:
      return None
    return self.operation.attributes["outer_dims_perm"]

  @outer_dims_perm.setter
  def outer_dims_perm(self, value):
    if value is not None:
      self.operation.attributes["outer_dims_perm"] = value
    elif "outer_dims_perm" in self.operation.attributes:
      del self.operation.attributes["outer_dims_perm"]

  @outer_dims_perm.deleter
  def outer_dims_perm(self):
    del self.operation.attributes["outer_dims_perm"]

  @builtins.property
  def inner_dims_pos(self):
    return self.operation.attributes["inner_dims_pos"]

  @inner_dims_pos.setter
  def inner_dims_pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inner_dims_pos"] = value

  @builtins.property
  def static_inner_tiles(self):
    return self.operation.attributes["static_inner_tiles"]

  @static_inner_tiles.setter
  def static_inner_tiles(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_inner_tiles"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def pack(source, dest, inner_dims_pos, inner_tiles, static_inner_tiles, *, padding_value=None, outer_dims_perm=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PackOp(source=source, dest=dest, inner_dims_pos=inner_dims_pos, inner_tiles=inner_tiles, static_inner_tiles=static_inner_tiles, padding_value=padding_value, outer_dims_perm=outer_dims_perm, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PadOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.pad"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, result, source, low, high, static_low, static_high, *, nofold=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(low))
    operands.append(_get_op_results_or_values(high))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_low"] = (static_low if (
    issubclass(type(static_low), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_low, context=_ods_context))
    attributes["static_high"] = (static_high if (
    issubclass(type(static_high), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_high, context=_ods_context))
    if bool(nofold): attributes["nofold"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def low(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def high(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def static_low(self):
    return self.operation.attributes["static_low"]

  @static_low.setter
  def static_low(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_low"] = value

  @builtins.property
  def static_high(self):
    return self.operation.attributes["static_high"]

  @static_high.setter
  def static_high(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_high"] = value

  @builtins.property
  def nofold(self):
    return "nofold" in self.operation.attributes

  @nofold.setter
  def nofold(self, value):
    if bool(value):
      self.operation.attributes["nofold"] = _ods_ir.UnitAttr.get()
    elif "nofold" in self.operation.attributes:
      del self.operation.attributes["nofold"]

  @nofold.deleter
  def nofold(self):
    del self.operation.attributes["nofold"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

  @builtins.property
  def region(self):
    return self.regions[0]

def pad(result, source, low, high, static_low, static_high, *, nofold=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(PadOp(result=result, source=source, low=low, high=high, static_low=static_low, static_high=static_high, nofold=nofold, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ParallelInsertSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.parallel_insert_slice"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_results_or_values(offsets))
    operands.append(_get_op_results_or_values(sizes))
    operands.append(_get_op_results_or_values(strides))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_offsets"] = (static_offsets if (
    issubclass(type(static_offsets), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_offsets, context=_ods_context))
    attributes["static_sizes"] = (static_sizes if (
    issubclass(type(static_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_sizes, context=_ods_context))
    attributes["static_strides"] = (static_strides if (
    issubclass(type(static_strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_strides, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def dest(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def offsets(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def sizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def strides(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def static_offsets(self):
    return self.operation.attributes["static_offsets"]

  @static_offsets.setter
  def static_offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_offsets"] = value

  @builtins.property
  def static_sizes(self):
    return self.operation.attributes["static_sizes"]

  @static_sizes.setter
  def static_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_sizes"] = value

  @builtins.property
  def static_strides(self):
    return self.operation.attributes["static_strides"]

  @static_strides.setter
  def static_strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_strides"] = value

def parallel_insert_slice(source, dest, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ParallelInsertSliceOp(source=source, dest=dest, offsets=offsets, sizes=sizes, strides=strides, static_offsets=static_offsets, static_sizes=static_sizes, static_strides=static_strides, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class RankOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.rank"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

def rank(tensor, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(RankOp(tensor=tensor, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(shape))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def shape(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def reshape(result, source, shape, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ReshapeOp(result=result, source=source, shape=shape, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ScatterOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.scatter"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, dest, indices, scatter_dims, *, unique=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_result_or_value(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["scatter_dims"] = (scatter_dims if (
    issubclass(type(scatter_dims), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(scatter_dims, context=_ods_context))
    if bool(unique): attributes["unique"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    return self.operation.operands[2]

  @builtins.property
  def scatter_dims(self):
    return self.operation.attributes["scatter_dims"]

  @scatter_dims.setter
  def scatter_dims(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["scatter_dims"] = value

  @builtins.property
  def unique(self):
    return "unique" in self.operation.attributes

  @unique.setter
  def unique(self, value):
    if bool(value):
      self.operation.attributes["unique"] = _ods_ir.UnitAttr.get()
    elif "unique" in self.operation.attributes:
      del self.operation.attributes["unique"]

  @unique.deleter
  def unique(self):
    del self.operation.attributes["unique"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def scatter(result, source, dest, indices, scatter_dims, *, unique=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ScatterOp(result=result, source=source, dest=dest, indices=indices, scatter_dims=scatter_dims, unique=unique, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SplatOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.splat"

  _ODS_REGIONS = (0, True)

  def __init__(self, aggregate, input, dynamicSizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.extend(_get_op_results_or_values(dynamicSizes))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(aggregate)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamicSizes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def aggregate(self):
    return self.operation.results[0]

def splat(aggregate, input, dynamic_sizes, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(SplatOp(aggregate=aggregate, input=input, dynamicSizes=dynamic_sizes, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnPackOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.unpack"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, dest, inner_dims_pos, inner_tiles, static_inner_tiles, *, outer_dims_perm=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(dest))
    operands.extend(_get_op_results_or_values(inner_tiles))
    _ods_context = _ods_get_default_loc_context(loc)
    if outer_dims_perm is not None: attributes["outer_dims_perm"] = (outer_dims_perm if (
        issubclass(type(outer_dims_perm), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(outer_dims_perm, context=_ods_context))
    attributes["inner_dims_pos"] = (inner_dims_pos if (
    issubclass(type(inner_dims_pos), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(inner_dims_pos, context=_ods_context))
    attributes["static_inner_tiles"] = (static_inner_tiles if (
    issubclass(type(static_inner_tiles), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_inner_tiles, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

  @builtins.property
  def inner_tiles(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def outer_dims_perm(self):
    if "outer_dims_perm" not in self.operation.attributes:
      return None
    return self.operation.attributes["outer_dims_perm"]

  @outer_dims_perm.setter
  def outer_dims_perm(self, value):
    if value is not None:
      self.operation.attributes["outer_dims_perm"] = value
    elif "outer_dims_perm" in self.operation.attributes:
      del self.operation.attributes["outer_dims_perm"]

  @outer_dims_perm.deleter
  def outer_dims_perm(self):
    del self.operation.attributes["outer_dims_perm"]

  @builtins.property
  def inner_dims_pos(self):
    return self.operation.attributes["inner_dims_pos"]

  @inner_dims_pos.setter
  def inner_dims_pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inner_dims_pos"] = value

  @builtins.property
  def static_inner_tiles(self):
    return self.operation.attributes["static_inner_tiles"]

  @static_inner_tiles.setter
  def static_inner_tiles(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_inner_tiles"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def unpack(source, dest, inner_dims_pos, inner_tiles, static_inner_tiles, *, outer_dims_perm=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(UnPackOp(source=source, dest=dest, inner_dims_pos=inner_dims_pos, inner_tiles=inner_tiles, static_inner_tiles=static_inner_tiles, outer_dims_perm=outer_dims_perm, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "tensor.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

def yield_(value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(YieldOp(value=value, loc=loc, ip=ip))
