
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class BinaryFn(IntEnum):
    """allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8"""

    add = 0
    sub = 1
    mul = 2
    div = 3
    div_unsigned = 4
    max_signed = 5
    min_signed = 6
    max_unsigned = 7
    min_unsigned = 8

    def __str__(self):
        if self is BinaryFn.add:
            return "add"
        if self is BinaryFn.sub:
            return "sub"
        if self is BinaryFn.mul:
            return "mul"
        if self is BinaryFn.div:
            return "div"
        if self is BinaryFn.div_unsigned:
            return "div_unsigned"
        if self is BinaryFn.max_signed:
            return "max_signed"
        if self is BinaryFn.min_signed:
            return "min_signed"
        if self is BinaryFn.max_unsigned:
            return "max_unsigned"
        if self is BinaryFn.min_unsigned:
            return "min_unsigned"
        raise ValueError("Unknown BinaryFn enum entry.")



@register_attribute_builder("BinaryFn")
def _binaryfn(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class IteratorType(IntEnum):
    """Iterator type"""

    parallel = 0
    reduction = 1

    def __str__(self):
        if self is IteratorType.parallel:
            return "parallel"
        if self is IteratorType.reduction:
            return "reduction"
        raise ValueError("Unknown IteratorType enum entry.")



@register_attribute_builder("IteratorType")
def _iteratortype(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TypeFn(IntEnum):
    """allowed 32-bit signless integer cases: 0, 1"""

    cast_signed = 0
    cast_unsigned = 1

    def __str__(self):
        if self is TypeFn.cast_signed:
            return "cast_signed"
        if self is TypeFn.cast_unsigned:
            return "cast_unsigned"
        raise ValueError("Unknown TypeFn enum entry.")



@register_attribute_builder("TypeFn")
def _typefn(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class UnaryFn(IntEnum):
    """allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5"""

    exp = 0
    log = 1
    abs = 2
    ceil = 3
    floor = 4
    negf = 5

    def __str__(self):
        if self is UnaryFn.exp:
            return "exp"
        if self is UnaryFn.log:
            return "log"
        if self is UnaryFn.abs:
            return "abs"
        if self is UnaryFn.ceil:
            return "ceil"
        if self is UnaryFn.floor:
            return "floor"
        if self is UnaryFn.negf:
            return "negf"
        raise ValueError("Unknown UnaryFn enum entry.")



@register_attribute_builder("UnaryFn")
def _unaryfn(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

@register_attribute_builder("BinaryFnAttr")
def _binaryfnattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.binary_fn<{str(x)}>', context=context)

@register_attribute_builder("IteratorTypeEnum")
def _iteratortypeenum(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.iterator_type<{str(x)}>', context=context)

@register_attribute_builder("TypeFnAttr")
def _typefnattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.type_fn<{str(x)}>', context=context)

@register_attribute_builder("UnaryFnAttr")
def _unaryfnattr(x, context):
    return _ods_ir.Attribute.parse(f'#linalg.unary_fn<{str(x)}>', context=context)

