
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    SubClassValueT as _SubClassValueT,
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "omp"
  pass


@_ods_cext.register_operation(_Dialect)
class AtomicCaptureOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.capture"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, hint_val=None, memory_order_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if hint_val is not None: attributes["hint_val"] = (hint_val if (
        issubclass(type(hint_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint_val, context=_ods_context))
    if memory_order_val is not None: attributes["memory_order_val"] = (memory_order_val if (
        issubclass(type(memory_order_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def hint_val(self):
    if "hint_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint_val"]

  @hint_val.setter
  def hint_val(self, value):
    if value is not None:
      self.operation.attributes["hint_val"] = value
    elif "hint_val" in self.operation.attributes:
      del self.operation.attributes["hint_val"]

  @hint_val.deleter
  def hint_val(self):
    del self.operation.attributes["hint_val"]

  @builtins.property
  def memory_order_val(self):
    if "memory_order_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order_val"]

  @memory_order_val.setter
  def memory_order_val(self, value):
    if value is not None:
      self.operation.attributes["memory_order_val"] = value
    elif "memory_order_val" in self.operation.attributes:
      del self.operation.attributes["memory_order_val"]

  @memory_order_val.deleter
  def memory_order_val(self):
    del self.operation.attributes["memory_order_val"]

  @builtins.property
  def region(self):
    return self.regions[0]

def atomic_capture(*, hint_val=None, memory_order_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AtomicCaptureOp(hint_val=hint_val, memory_order_val=memory_order_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AtomicReadOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.read"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, v, element_type, *, hint_val=None, memory_order_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    operands.append(_get_op_result_or_value(v))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["element_type"] = (element_type if (
    issubclass(type(element_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(element_type, context=_ods_context))
    if hint_val is not None: attributes["hint_val"] = (hint_val if (
        issubclass(type(hint_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint_val, context=_ods_context))
    if memory_order_val is not None: attributes["memory_order_val"] = (memory_order_val if (
        issubclass(type(memory_order_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def v(self):
    return self.operation.operands[1]

  @builtins.property
  def element_type(self):
    return self.operation.attributes["element_type"]

  @element_type.setter
  def element_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["element_type"] = value

  @builtins.property
  def hint_val(self):
    if "hint_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint_val"]

  @hint_val.setter
  def hint_val(self, value):
    if value is not None:
      self.operation.attributes["hint_val"] = value
    elif "hint_val" in self.operation.attributes:
      del self.operation.attributes["hint_val"]

  @hint_val.deleter
  def hint_val(self):
    del self.operation.attributes["hint_val"]

  @builtins.property
  def memory_order_val(self):
    if "memory_order_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order_val"]

  @memory_order_val.setter
  def memory_order_val(self, value):
    if value is not None:
      self.operation.attributes["memory_order_val"] = value
    elif "memory_order_val" in self.operation.attributes:
      del self.operation.attributes["memory_order_val"]

  @memory_order_val.deleter
  def memory_order_val(self):
    del self.operation.attributes["memory_order_val"]

def atomic_read(x, v, element_type, *, hint_val=None, memory_order_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AtomicReadOp(x=x, v=v, element_type=element_type, hint_val=hint_val, memory_order_val=memory_order_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AtomicUpdateOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.update"

  _ODS_REGIONS = (1, True)

  def __init__(self, x, *, hint_val=None, memory_order_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    _ods_context = _ods_get_default_loc_context(loc)
    if hint_val is not None: attributes["hint_val"] = (hint_val if (
        issubclass(type(hint_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint_val, context=_ods_context))
    if memory_order_val is not None: attributes["memory_order_val"] = (memory_order_val if (
        issubclass(type(memory_order_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def hint_val(self):
    if "hint_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint_val"]

  @hint_val.setter
  def hint_val(self, value):
    if value is not None:
      self.operation.attributes["hint_val"] = value
    elif "hint_val" in self.operation.attributes:
      del self.operation.attributes["hint_val"]

  @hint_val.deleter
  def hint_val(self):
    del self.operation.attributes["hint_val"]

  @builtins.property
  def memory_order_val(self):
    if "memory_order_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order_val"]

  @memory_order_val.setter
  def memory_order_val(self, value):
    if value is not None:
      self.operation.attributes["memory_order_val"] = value
    elif "memory_order_val" in self.operation.attributes:
      del self.operation.attributes["memory_order_val"]

  @memory_order_val.deleter
  def memory_order_val(self):
    del self.operation.attributes["memory_order_val"]

  @builtins.property
  def region(self):
    return self.regions[0]

def atomic_update(x, *, hint_val=None, memory_order_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AtomicUpdateOp(x=x, hint_val=hint_val, memory_order_val=memory_order_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AtomicWriteOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.atomic.write"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, expr, *, hint_val=None, memory_order_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    operands.append(_get_op_result_or_value(expr))
    _ods_context = _ods_get_default_loc_context(loc)
    if hint_val is not None: attributes["hint_val"] = (hint_val if (
        issubclass(type(hint_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint_val, context=_ods_context))
    if memory_order_val is not None: attributes["memory_order_val"] = (memory_order_val if (
        issubclass(type(memory_order_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('MemoryOrderKindAttr')) else
          _ods_ir.AttrBuilder.get('MemoryOrderKindAttr')(memory_order_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def expr(self):
    return self.operation.operands[1]

  @builtins.property
  def hint_val(self):
    if "hint_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["hint_val"]

  @hint_val.setter
  def hint_val(self, value):
    if value is not None:
      self.operation.attributes["hint_val"] = value
    elif "hint_val" in self.operation.attributes:
      del self.operation.attributes["hint_val"]

  @hint_val.deleter
  def hint_val(self):
    del self.operation.attributes["hint_val"]

  @builtins.property
  def memory_order_val(self):
    if "memory_order_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory_order_val"]

  @memory_order_val.setter
  def memory_order_val(self, value):
    if value is not None:
      self.operation.attributes["memory_order_val"] = value
    elif "memory_order_val" in self.operation.attributes:
      del self.operation.attributes["memory_order_val"]

  @memory_order_val.deleter
  def memory_order_val(self):
    del self.operation.attributes["memory_order_val"]

def atomic_write(x, expr, *, hint_val=None, memory_order_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AtomicWriteOp(x=x, expr=expr, hint_val=hint_val, memory_order_val=memory_order_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BarrierOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def barrier(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BarrierOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CancelOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.cancel"

  _ODS_REGIONS = (0, True)

  def __init__(self, cancellation_construct_type_val, *, if_expr=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if if_expr is not None: operands.append(_get_op_result_or_value(if_expr))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cancellation_construct_type_val"] = (cancellation_construct_type_val if (
    issubclass(type(cancellation_construct_type_val), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('CancellationConstructTypeAttr')) else
      _ods_ir.AttrBuilder.get('CancellationConstructTypeAttr')(cancellation_construct_type_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def cancellation_construct_type_val(self):
    return self.operation.attributes["cancellation_construct_type_val"]

  @cancellation_construct_type_val.setter
  def cancellation_construct_type_val(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cancellation_construct_type_val"] = value

def cancel(cancellation_construct_type_val, *, if_expr=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CancelOp(cancellation_construct_type_val=cancellation_construct_type_val, if_expr=if_expr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CancellationPointOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.cancellationpoint"

  _ODS_REGIONS = (0, True)

  def __init__(self, cancellation_construct_type_val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cancellation_construct_type_val"] = (cancellation_construct_type_val if (
    issubclass(type(cancellation_construct_type_val), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('CancellationConstructTypeAttr')) else
      _ods_ir.AttrBuilder.get('CancellationConstructTypeAttr')(cancellation_construct_type_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cancellation_construct_type_val(self):
    return self.operation.attributes["cancellation_construct_type_val"]

  @cancellation_construct_type_val.setter
  def cancellation_construct_type_val(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cancellation_construct_type_val"] = value

def cancellationpoint(cancellation_construct_type_val, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CancellationPointOp(cancellation_construct_type_val=cancellation_construct_type_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CriticalDeclareOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.critical.declare"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, *, hint_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if hint_val is not None: attributes["hint_val"] = (hint_val if (
        issubclass(type(hint_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(hint_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def hint_val(self):
    return self.operation.attributes["hint_val"]

  @hint_val.setter
  def hint_val(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["hint_val"] = value

def critical_declare(sym_name, *, hint_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CriticalDeclareOp(sym_name=sym_name, hint_val=hint_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CriticalOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.critical"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, name=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if name is not None: attributes["name"] = (name if (
        issubclass(type(name), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def region(self):
    return self.regions[0]

def critical(*, name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CriticalOp(name=name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DataBoundsOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.bounds"

  _ODS_OPERAND_SEGMENTS = [0,0,0,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, lower_bound=None, upper_bound=None, extent=None, stride=None, stride_in_bytes=None, start_idx=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lower_bound) if lower_bound is not None else None)
    operands.append(_get_op_result_or_value(upper_bound) if upper_bound is not None else None)
    operands.append(_get_op_result_or_value(extent) if extent is not None else None)
    operands.append(_get_op_result_or_value(stride) if stride is not None else None)
    operands.append(_get_op_result_or_value(start_idx) if start_idx is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if stride_in_bytes is not None: attributes["stride_in_bytes"] = (stride_in_bytes if (
        issubclass(type(stride_in_bytes), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(stride_in_bytes, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lower_bound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def upper_bound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def extent(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def stride(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def start_idx(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def stride_in_bytes(self):
    return self.operation.attributes["stride_in_bytes"]

  @stride_in_bytes.setter
  def stride_in_bytes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["stride_in_bytes"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def bounds(result, *, lower_bound=None, upper_bound=None, extent=None, stride=None, stride_in_bytes=None, start_idx=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(DataBoundsOp(result=result, lower_bound=lower_bound, upper_bound=upper_bound, extent=extent, stride=stride, stride_in_bytes=stride_in_bytes, start_idx=start_idx, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DistributeOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.distribute"

  _ODS_OPERAND_SEGMENTS = [0,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocators_vars, *, dist_schedule_static=None, chunk_size=None, order_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(chunk_size) if chunk_size is not None else None)
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(dist_schedule_static): attributes["dist_schedule_static"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if order_val is not None: attributes["order_val"] = (order_val if (
        issubclass(type(order_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderKindAttr')) else
          _ods_ir.AttrBuilder.get('OrderKindAttr')(order_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def chunk_size(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def dist_schedule_static(self):
    return "dist_schedule_static" in self.operation.attributes

  @dist_schedule_static.setter
  def dist_schedule_static(self, value):
    if bool(value):
      self.operation.attributes["dist_schedule_static"] = _ods_ir.UnitAttr.get()
    elif "dist_schedule_static" in self.operation.attributes:
      del self.operation.attributes["dist_schedule_static"]

  @dist_schedule_static.deleter
  def dist_schedule_static(self):
    del self.operation.attributes["dist_schedule_static"]

  @builtins.property
  def order_val(self):
    if "order_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["order_val"]

  @order_val.setter
  def order_val(self, value):
    if value is not None:
      self.operation.attributes["order_val"] = value
    elif "order_val" in self.operation.attributes:
      del self.operation.attributes["order_val"]

  @order_val.deleter
  def order_val(self):
    del self.operation.attributes["order_val"]

  @builtins.property
  def region(self):
    return self.regions[0]

def distribute(allocate_vars, allocators_vars, *, dist_schedule_static=None, chunk_size=None, order_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DistributeOp(allocate_vars=allocate_vars, allocators_vars=allocators_vars, dist_schedule_static=dist_schedule_static, chunk_size=chunk_size, order_val=order_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FlushOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.flush"

  _ODS_REGIONS = (0, True)

  def __init__(self, varList, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(varList))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def varList(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def flush(var_list, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FlushOp(varList=var_list, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MapInfoOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.map_info"

  _ODS_OPERAND_SEGMENTS = [1,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, omp_ptr, var_ptr, var_type, bounds, *, var_ptr_ptr=None, map_type=None, map_capture_type=None, name=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(var_ptr))
    operands.append(_get_op_result_or_value(var_ptr_ptr) if var_ptr_ptr is not None else None)
    operands.append(_get_op_results_or_values(bounds))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["var_type"] = (var_type if (
    issubclass(type(var_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(var_type, context=_ods_context))
    if map_type is not None: attributes["map_type"] = (map_type if (
        issubclass(type(map_type), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('UI64Attr')) else
          _ods_ir.AttrBuilder.get('UI64Attr')(map_type, context=_ods_context))
    if map_capture_type is not None: attributes["map_capture_type"] = (map_capture_type if (
        issubclass(type(map_capture_type), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('VariableCaptureKindAttr')) else
          _ods_ir.AttrBuilder.get('VariableCaptureKindAttr')(map_capture_type, context=_ods_context))
    if name is not None: attributes["name"] = (name if (
        issubclass(type(name), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    results.append(omp_ptr)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def var_ptr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def var_ptr_ptr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def bounds(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def var_type(self):
    return self.operation.attributes["var_type"]

  @var_type.setter
  def var_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["var_type"] = value

  @builtins.property
  def map_type(self):
    if "map_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["map_type"]

  @map_type.setter
  def map_type(self, value):
    if value is not None:
      self.operation.attributes["map_type"] = value
    elif "map_type" in self.operation.attributes:
      del self.operation.attributes["map_type"]

  @map_type.deleter
  def map_type(self):
    del self.operation.attributes["map_type"]

  @builtins.property
  def map_capture_type(self):
    if "map_capture_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["map_capture_type"]

  @map_capture_type.setter
  def map_capture_type(self, value):
    if value is not None:
      self.operation.attributes["map_capture_type"] = value
    elif "map_capture_type" in self.operation.attributes:
      del self.operation.attributes["map_capture_type"]

  @map_capture_type.deleter
  def map_capture_type(self):
    del self.operation.attributes["map_capture_type"]

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def omp_ptr(self):
    return self.operation.results[0]

def map_info(omp_ptr, var_ptr, var_type, bounds, *, var_ptr_ptr=None, map_type=None, map_capture_type=None, name=None, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(MapInfoOp(omp_ptr=omp_ptr, var_ptr=var_ptr, var_type=var_type, bounds=bounds, var_ptr_ptr=var_ptr_ptr, map_type=map_type, map_capture_type=map_capture_type, name=name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MasterOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.master"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def region(self):
    return self.regions[0]

def master(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MasterOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class OrderedOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.ordered"

  _ODS_REGIONS = (0, True)

  def __init__(self, depend_vec_vars, *, depend_type_val=None, num_loops_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(depend_vec_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if depend_type_val is not None: attributes["depend_type_val"] = (depend_type_val if (
        issubclass(type(depend_type_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ClauseDependAttr')) else
          _ods_ir.AttrBuilder.get('ClauseDependAttr')(depend_type_val, context=_ods_context))
    if num_loops_val is not None: attributes["num_loops_val"] = (num_loops_val if (
        issubclass(type(num_loops_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(num_loops_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def depend_vec_vars(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def depend_type_val(self):
    if "depend_type_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["depend_type_val"]

  @depend_type_val.setter
  def depend_type_val(self, value):
    if value is not None:
      self.operation.attributes["depend_type_val"] = value
    elif "depend_type_val" in self.operation.attributes:
      del self.operation.attributes["depend_type_val"]

  @depend_type_val.deleter
  def depend_type_val(self):
    del self.operation.attributes["depend_type_val"]

  @builtins.property
  def num_loops_val(self):
    if "num_loops_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["num_loops_val"]

  @num_loops_val.setter
  def num_loops_val(self, value):
    if value is not None:
      self.operation.attributes["num_loops_val"] = value
    elif "num_loops_val" in self.operation.attributes:
      del self.operation.attributes["num_loops_val"]

  @num_loops_val.deleter
  def num_loops_val(self):
    del self.operation.attributes["num_loops_val"]

def ordered(depend_vec_vars, *, depend_type_val=None, num_loops_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(OrderedOp(depend_vec_vars=depend_vec_vars, depend_type_val=depend_type_val, num_loops_val=num_loops_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class OrderedRegionOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.ordered_region"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, simd=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(simd): attributes["simd"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def simd(self):
    return "simd" in self.operation.attributes

  @simd.setter
  def simd(self, value):
    if bool(value):
      self.operation.attributes["simd"] = _ods_ir.UnitAttr.get()
    elif "simd" in self.operation.attributes:
      del self.operation.attributes["simd"]

  @simd.deleter
  def simd(self):
    del self.operation.attributes["simd"]

  @builtins.property
  def region(self):
    return self.regions[0]

def ordered_region(*, simd=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(OrderedRegionOp(simd=simd, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ParallelOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.parallel"

  _ODS_OPERAND_SEGMENTS = [0,0,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocators_vars, reduction_vars, *, if_expr_var=None, num_threads_var=None, reductions=None, proc_bind_val=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(if_expr_var) if if_expr_var is not None else None)
    operands.append(_get_op_result_or_value(num_threads_var) if num_threads_var is not None else None)
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if reductions is not None: attributes["reductions"] = (reductions if (
        issubclass(type(reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reductions, context=_ods_context))
    if proc_bind_val is not None: attributes["proc_bind_val"] = (proc_bind_val if (
        issubclass(type(proc_bind_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ProcBindKindAttr')) else
          _ods_ir.AttrBuilder.get('ProcBindKindAttr')(proc_bind_val, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr_var(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def num_threads_var(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def reductions(self):
    if "reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["reductions"]

  @reductions.setter
  def reductions(self, value):
    if value is not None:
      self.operation.attributes["reductions"] = value
    elif "reductions" in self.operation.attributes:
      del self.operation.attributes["reductions"]

  @reductions.deleter
  def reductions(self):
    del self.operation.attributes["reductions"]

  @builtins.property
  def proc_bind_val(self):
    if "proc_bind_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["proc_bind_val"]

  @proc_bind_val.setter
  def proc_bind_val(self, value):
    if value is not None:
      self.operation.attributes["proc_bind_val"] = value
    elif "proc_bind_val" in self.operation.attributes:
      del self.operation.attributes["proc_bind_val"]

  @proc_bind_val.deleter
  def proc_bind_val(self):
    del self.operation.attributes["proc_bind_val"]

  @builtins.property
  def region(self):
    return self.regions[0]

def parallel(allocate_vars, allocators_vars, reduction_vars, *, if_expr_var=None, num_threads_var=None, reductions=None, proc_bind_val=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ParallelOp(allocate_vars=allocate_vars, allocators_vars=allocators_vars, reduction_vars=reduction_vars, if_expr_var=if_expr_var, num_threads_var=num_threads_var, reductions=reductions, proc_bind_val=proc_bind_val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReductionDeclareOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.reduction.declare"

  _ODS_REGIONS = (3, True)

  def __init__(self, sym_name, type_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["type"] = (type_ if (
    issubclass(type(type_), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(type_, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def initializerRegion(self):
    return self.regions[0]

  @builtins.property
  def reductionRegion(self):
    return self.regions[1]

  @builtins.property
  def atomicReductionRegion(self):
    return self.regions[2]

def reduction_declare(sym_name, type_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReductionDeclareOp(sym_name=sym_name, type_=type_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReductionOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.reduction"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, accumulator, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(accumulator))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def accumulator(self):
    return self.operation.operands[1]

def reduction(operand, accumulator, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReductionOp(operand=operand, accumulator=accumulator, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SectionOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.section"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def region(self):
    return self.regions[0]

def section(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SectionOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SectionsOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.sections"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, reduction_vars, allocate_vars, allocators_vars, *, reductions=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(reduction_vars))
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if reductions is not None: attributes["reductions"] = (reductions if (
        issubclass(type(reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reductions, context=_ods_context))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def reductions(self):
    if "reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["reductions"]

  @reductions.setter
  def reductions(self, value):
    if value is not None:
      self.operation.attributes["reductions"] = value
    elif "reductions" in self.operation.attributes:
      del self.operation.attributes["reductions"]

  @reductions.deleter
  def reductions(self):
    del self.operation.attributes["reductions"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def region(self):
    return self.regions[0]

def sections(reduction_vars, allocate_vars, allocators_vars, *, reductions=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SectionsOp(reduction_vars=reduction_vars, allocate_vars=allocate_vars, allocators_vars=allocators_vars, reductions=reductions, nowait=nowait, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SimdLoopOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.simdloop"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,-1,0,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, lowerBound, upperBound, step, aligned_vars, nontemporal_vars, *, alignment_values=None, if_expr=None, order_val=None, simdlen=None, safelen=None, inclusive=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(lowerBound))
    operands.append(_get_op_results_or_values(upperBound))
    operands.append(_get_op_results_or_values(step))
    operands.append(_get_op_results_or_values(aligned_vars))
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_results_or_values(nontemporal_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment_values is not None: attributes["alignment_values"] = (alignment_values if (
        issubclass(type(alignment_values), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('I64ArrayAttr')(alignment_values, context=_ods_context))
    if order_val is not None: attributes["order_val"] = (order_val if (
        issubclass(type(order_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderKindAttr')) else
          _ods_ir.AttrBuilder.get('OrderKindAttr')(order_val, context=_ods_context))
    if simdlen is not None: attributes["simdlen"] = (simdlen if (
        issubclass(type(simdlen), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(simdlen, context=_ods_context))
    if safelen is not None: attributes["safelen"] = (safelen if (
        issubclass(type(safelen), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(safelen, context=_ods_context))
    if bool(inclusive): attributes["inclusive"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lowerBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def upperBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def step(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def aligned_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def nontemporal_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def alignment_values(self):
    if "alignment_values" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment_values"]

  @alignment_values.setter
  def alignment_values(self, value):
    if value is not None:
      self.operation.attributes["alignment_values"] = value
    elif "alignment_values" in self.operation.attributes:
      del self.operation.attributes["alignment_values"]

  @alignment_values.deleter
  def alignment_values(self):
    del self.operation.attributes["alignment_values"]

  @builtins.property
  def order_val(self):
    if "order_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["order_val"]

  @order_val.setter
  def order_val(self, value):
    if value is not None:
      self.operation.attributes["order_val"] = value
    elif "order_val" in self.operation.attributes:
      del self.operation.attributes["order_val"]

  @order_val.deleter
  def order_val(self):
    del self.operation.attributes["order_val"]

  @builtins.property
  def simdlen(self):
    if "simdlen" not in self.operation.attributes:
      return None
    return self.operation.attributes["simdlen"]

  @simdlen.setter
  def simdlen(self, value):
    if value is not None:
      self.operation.attributes["simdlen"] = value
    elif "simdlen" in self.operation.attributes:
      del self.operation.attributes["simdlen"]

  @simdlen.deleter
  def simdlen(self):
    del self.operation.attributes["simdlen"]

  @builtins.property
  def safelen(self):
    if "safelen" not in self.operation.attributes:
      return None
    return self.operation.attributes["safelen"]

  @safelen.setter
  def safelen(self, value):
    if value is not None:
      self.operation.attributes["safelen"] = value
    elif "safelen" in self.operation.attributes:
      del self.operation.attributes["safelen"]

  @safelen.deleter
  def safelen(self):
    del self.operation.attributes["safelen"]

  @builtins.property
  def inclusive(self):
    return "inclusive" in self.operation.attributes

  @inclusive.setter
  def inclusive(self, value):
    if bool(value):
      self.operation.attributes["inclusive"] = _ods_ir.UnitAttr.get()
    elif "inclusive" in self.operation.attributes:
      del self.operation.attributes["inclusive"]

  @inclusive.deleter
  def inclusive(self):
    del self.operation.attributes["inclusive"]

  @builtins.property
  def region(self):
    return self.regions[0]

def simdloop(lower_bound, upper_bound, step, aligned_vars, nontemporal_vars, *, alignment_values=None, if_expr=None, order_val=None, simdlen=None, safelen=None, inclusive=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SimdLoopOp(lowerBound=lower_bound, upperBound=upper_bound, step=step, aligned_vars=aligned_vars, nontemporal_vars=nontemporal_vars, alignment_values=alignment_values, if_expr=if_expr, order_val=order_val, simdlen=simdlen, safelen=safelen, inclusive=inclusive, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SingleOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.single"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocators_vars, *, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def region(self):
    return self.regions[0]

def single(allocate_vars, allocators_vars, *, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SingleOp(allocate_vars=allocate_vars, allocators_vars=allocators_vars, nowait=nowait, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TargetOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target"

  _ODS_OPERAND_SEGMENTS = [0,0,0,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, map_operands, *, if_expr=None, device=None, thread_limit=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(device) if device is not None else None)
    operands.append(_get_op_result_or_value(thread_limit) if thread_limit is not None else None)
    operands.append(_get_op_results_or_values(map_operands))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def thread_limit(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def map_operands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def region(self):
    return self.regions[0]

def target(map_operands, *, if_expr=None, device=None, thread_limit=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TargetOp(map_operands=map_operands, if_expr=if_expr, device=device, thread_limit=thread_limit, nowait=nowait, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DataOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_data"

  _ODS_OPERAND_SEGMENTS = [0,0,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, use_device_ptr, use_device_addr, map_operands, *, if_expr=None, device=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(device) if device is not None else None)
    operands.append(_get_op_results_or_values(use_device_ptr))
    operands.append(_get_op_results_or_values(use_device_addr))
    operands.append(_get_op_results_or_values(map_operands))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def use_device_ptr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def use_device_addr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def map_operands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def region(self):
    return self.regions[0]

def target_data(use_device_ptr, use_device_addr, map_operands, *, if_expr=None, device=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DataOp(use_device_ptr=use_device_ptr, use_device_addr=use_device_addr, map_operands=map_operands, if_expr=if_expr, device=device, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class EnterDataOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_enter_data"

  _ODS_OPERAND_SEGMENTS = [0,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, map_operands, *, if_expr=None, device=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(device) if device is not None else None)
    operands.append(_get_op_results_or_values(map_operands))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def map_operands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

def target_enter_data(map_operands, *, if_expr=None, device=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(EnterDataOp(map_operands=map_operands, if_expr=if_expr, device=device, nowait=nowait, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExitDataOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_exit_data"

  _ODS_OPERAND_SEGMENTS = [0,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, map_operands, *, if_expr=None, device=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(device) if device is not None else None)
    operands.append(_get_op_results_or_values(map_operands))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def map_operands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

def target_exit_data(map_operands, *, if_expr=None, device=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ExitDataOp(map_operands=map_operands, if_expr=if_expr, device=device, nowait=nowait, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UpdateDataOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.target_update_data"

  _ODS_OPERAND_SEGMENTS = [0,0,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, motion_operands, *, if_expr=None, device=None, nowait=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(device) if device is not None else None)
    operands.append(_get_op_results_or_values(motion_operands))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def device(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def motion_operands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

def target_update_data(motion_operands, *, if_expr=None, device=None, nowait=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(UpdateDataOp(motion_operands=motion_operands, if_expr=if_expr, device=device, nowait=nowait, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TaskGroupOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskgroup"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, task_reduction_vars, allocate_vars, allocators_vars, *, task_reductions=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(task_reduction_vars))
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if task_reductions is not None: attributes["task_reductions"] = (task_reductions if (
        issubclass(type(task_reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(task_reductions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def task_reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def task_reductions(self):
    if "task_reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["task_reductions"]

  @task_reductions.setter
  def task_reductions(self, value):
    if value is not None:
      self.operation.attributes["task_reductions"] = value
    elif "task_reductions" in self.operation.attributes:
      del self.operation.attributes["task_reductions"]

  @task_reductions.deleter
  def task_reductions(self):
    del self.operation.attributes["task_reductions"]

  @builtins.property
  def region(self):
    return self.regions[0]

def taskgroup(task_reduction_vars, allocate_vars, allocators_vars, *, task_reductions=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TaskGroupOp(task_reduction_vars=task_reduction_vars, allocate_vars=allocate_vars, allocators_vars=allocators_vars, task_reductions=task_reductions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TaskLoopOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskloop"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,0,0,-1,-1,0,-1,-1,0,0,]

  _ODS_REGIONS = (1, True)

  def __init__(self, lowerBound, upperBound, step, in_reduction_vars, reduction_vars, allocate_vars, allocators_vars, *, inclusive=None, if_expr=None, final_expr=None, untied=None, mergeable=None, in_reductions=None, reductions=None, priority=None, grain_size=None, num_tasks=None, nogroup=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(lowerBound))
    operands.append(_get_op_results_or_values(upperBound))
    operands.append(_get_op_results_or_values(step))
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(final_expr) if final_expr is not None else None)
    operands.append(_get_op_results_or_values(in_reduction_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    operands.append(_get_op_result_or_value(priority) if priority is not None else None)
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    operands.append(_get_op_result_or_value(grain_size) if grain_size is not None else None)
    operands.append(_get_op_result_or_value(num_tasks) if num_tasks is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(inclusive): attributes["inclusive"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(untied): attributes["untied"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(mergeable): attributes["mergeable"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if in_reductions is not None: attributes["in_reductions"] = (in_reductions if (
        issubclass(type(in_reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(in_reductions, context=_ods_context))
    if reductions is not None: attributes["reductions"] = (reductions if (
        issubclass(type(reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reductions, context=_ods_context))
    if bool(nogroup): attributes["nogroup"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lowerBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def upperBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def step(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def final_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def in_reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range

  @builtins.property
  def priority(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 7)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 8)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 9)
    return operand_range

  @builtins.property
  def grain_size(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 10)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def num_tasks(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 11)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def inclusive(self):
    return "inclusive" in self.operation.attributes

  @inclusive.setter
  def inclusive(self, value):
    if bool(value):
      self.operation.attributes["inclusive"] = _ods_ir.UnitAttr.get()
    elif "inclusive" in self.operation.attributes:
      del self.operation.attributes["inclusive"]

  @inclusive.deleter
  def inclusive(self):
    del self.operation.attributes["inclusive"]

  @builtins.property
  def untied(self):
    return "untied" in self.operation.attributes

  @untied.setter
  def untied(self, value):
    if bool(value):
      self.operation.attributes["untied"] = _ods_ir.UnitAttr.get()
    elif "untied" in self.operation.attributes:
      del self.operation.attributes["untied"]

  @untied.deleter
  def untied(self):
    del self.operation.attributes["untied"]

  @builtins.property
  def mergeable(self):
    return "mergeable" in self.operation.attributes

  @mergeable.setter
  def mergeable(self, value):
    if bool(value):
      self.operation.attributes["mergeable"] = _ods_ir.UnitAttr.get()
    elif "mergeable" in self.operation.attributes:
      del self.operation.attributes["mergeable"]

  @mergeable.deleter
  def mergeable(self):
    del self.operation.attributes["mergeable"]

  @builtins.property
  def in_reductions(self):
    if "in_reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reductions"]

  @in_reductions.setter
  def in_reductions(self, value):
    if value is not None:
      self.operation.attributes["in_reductions"] = value
    elif "in_reductions" in self.operation.attributes:
      del self.operation.attributes["in_reductions"]

  @in_reductions.deleter
  def in_reductions(self):
    del self.operation.attributes["in_reductions"]

  @builtins.property
  def reductions(self):
    if "reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["reductions"]

  @reductions.setter
  def reductions(self, value):
    if value is not None:
      self.operation.attributes["reductions"] = value
    elif "reductions" in self.operation.attributes:
      del self.operation.attributes["reductions"]

  @reductions.deleter
  def reductions(self):
    del self.operation.attributes["reductions"]

  @builtins.property
  def nogroup(self):
    return "nogroup" in self.operation.attributes

  @nogroup.setter
  def nogroup(self, value):
    if bool(value):
      self.operation.attributes["nogroup"] = _ods_ir.UnitAttr.get()
    elif "nogroup" in self.operation.attributes:
      del self.operation.attributes["nogroup"]

  @nogroup.deleter
  def nogroup(self):
    del self.operation.attributes["nogroup"]

  @builtins.property
  def region(self):
    return self.regions[0]

def taskloop(lower_bound, upper_bound, step, in_reduction_vars, reduction_vars, allocate_vars, allocators_vars, *, inclusive=None, if_expr=None, final_expr=None, untied=None, mergeable=None, in_reductions=None, reductions=None, priority=None, grain_size=None, num_tasks=None, nogroup=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TaskLoopOp(lowerBound=lower_bound, upperBound=upper_bound, step=step, in_reduction_vars=in_reduction_vars, reduction_vars=reduction_vars, allocate_vars=allocate_vars, allocators_vars=allocators_vars, inclusive=inclusive, if_expr=if_expr, final_expr=final_expr, untied=untied, mergeable=mergeable, in_reductions=in_reductions, reductions=reductions, priority=priority, grain_size=grain_size, num_tasks=num_tasks, nogroup=nogroup, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TaskOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.task"

  _ODS_OPERAND_SEGMENTS = [0,0,-1,0,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, in_reduction_vars, depend_vars, allocate_vars, allocators_vars, *, if_expr=None, final_expr=None, untied=None, mergeable=None, in_reductions=None, priority=None, depends=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(final_expr) if final_expr is not None else None)
    operands.append(_get_op_results_or_values(in_reduction_vars))
    operands.append(_get_op_result_or_value(priority) if priority is not None else None)
    operands.append(_get_op_results_or_values(depend_vars))
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(untied): attributes["untied"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(mergeable): attributes["mergeable"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if in_reductions is not None: attributes["in_reductions"] = (in_reductions if (
        issubclass(type(in_reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(in_reductions, context=_ods_context))
    if depends is not None: attributes["depends"] = (depends if (
        issubclass(type(depends), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TaskDependArrayAttr')) else
          _ods_ir.AttrBuilder.get('TaskDependArrayAttr')(depends, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def final_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def in_reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def priority(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def depend_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range

  @builtins.property
  def untied(self):
    return "untied" in self.operation.attributes

  @untied.setter
  def untied(self, value):
    if bool(value):
      self.operation.attributes["untied"] = _ods_ir.UnitAttr.get()
    elif "untied" in self.operation.attributes:
      del self.operation.attributes["untied"]

  @untied.deleter
  def untied(self):
    del self.operation.attributes["untied"]

  @builtins.property
  def mergeable(self):
    return "mergeable" in self.operation.attributes

  @mergeable.setter
  def mergeable(self, value):
    if bool(value):
      self.operation.attributes["mergeable"] = _ods_ir.UnitAttr.get()
    elif "mergeable" in self.operation.attributes:
      del self.operation.attributes["mergeable"]

  @mergeable.deleter
  def mergeable(self):
    del self.operation.attributes["mergeable"]

  @builtins.property
  def in_reductions(self):
    if "in_reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["in_reductions"]

  @in_reductions.setter
  def in_reductions(self, value):
    if value is not None:
      self.operation.attributes["in_reductions"] = value
    elif "in_reductions" in self.operation.attributes:
      del self.operation.attributes["in_reductions"]

  @in_reductions.deleter
  def in_reductions(self):
    del self.operation.attributes["in_reductions"]

  @builtins.property
  def depends(self):
    if "depends" not in self.operation.attributes:
      return None
    return self.operation.attributes["depends"]

  @depends.setter
  def depends(self, value):
    if value is not None:
      self.operation.attributes["depends"] = value
    elif "depends" in self.operation.attributes:
      del self.operation.attributes["depends"]

  @depends.deleter
  def depends(self):
    del self.operation.attributes["depends"]

  @builtins.property
  def region(self):
    return self.regions[0]

def task(in_reduction_vars, depend_vars, allocate_vars, allocators_vars, *, if_expr=None, final_expr=None, untied=None, mergeable=None, in_reductions=None, priority=None, depends=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TaskOp(in_reduction_vars=in_reduction_vars, depend_vars=depend_vars, allocate_vars=allocate_vars, allocators_vars=allocators_vars, if_expr=if_expr, final_expr=final_expr, untied=untied, mergeable=mergeable, in_reductions=in_reductions, priority=priority, depends=depends, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TaskwaitOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskwait"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def taskwait(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TaskwaitOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TaskyieldOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.taskyield"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def taskyield(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TaskyieldOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TeamsOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.teams"

  _ODS_OPERAND_SEGMENTS = [0,0,0,0,-1,-1,-1,]

  _ODS_REGIONS = (1, True)

  def __init__(self, allocate_vars, allocators_vars, reduction_vars, *, num_teams_lower=None, num_teams_upper=None, if_expr=None, thread_limit=None, reductions=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(num_teams_lower) if num_teams_lower is not None else None)
    operands.append(_get_op_result_or_value(num_teams_upper) if num_teams_upper is not None else None)
    operands.append(_get_op_result_or_value(if_expr) if if_expr is not None else None)
    operands.append(_get_op_result_or_value(thread_limit) if thread_limit is not None else None)
    operands.append(_get_op_results_or_values(allocate_vars))
    operands.append(_get_op_results_or_values(allocators_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    _ods_context = _ods_get_default_loc_context(loc)
    if reductions is not None: attributes["reductions"] = (reductions if (
        issubclass(type(reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reductions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def num_teams_lower(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def num_teams_upper(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def if_expr(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def thread_limit(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def allocate_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def allocators_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range

  @builtins.property
  def reductions(self):
    if "reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["reductions"]

  @reductions.setter
  def reductions(self, value):
    if value is not None:
      self.operation.attributes["reductions"] = value
    elif "reductions" in self.operation.attributes:
      del self.operation.attributes["reductions"]

  @reductions.deleter
  def reductions(self):
    del self.operation.attributes["reductions"]

  @builtins.property
  def region(self):
    return self.regions[0]

def teams(allocate_vars, allocators_vars, reduction_vars, *, num_teams_lower=None, num_teams_upper=None, if_expr=None, thread_limit=None, reductions=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TeamsOp(allocate_vars=allocate_vars, allocators_vars=allocators_vars, reduction_vars=reduction_vars, num_teams_lower=num_teams_lower, num_teams_upper=num_teams_upper, if_expr=if_expr, thread_limit=thread_limit, reductions=reductions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TerminatorOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.terminator"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def terminator(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TerminatorOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ThreadprivateOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.threadprivate"

  _ODS_REGIONS = (0, True)

  def __init__(self, tls_addr, sym_addr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(sym_addr))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(tls_addr)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_addr(self):
    return self.operation.operands[0]

  @builtins.property
  def tls_addr(self):
    return self.operation.results[0]

def threadprivate(tls_addr, sym_addr, *, loc=None, ip=None) -> _SubClassValueT:
  return _get_op_result_or_op_results(ThreadprivateOp(tls_addr=tls_addr, sym_addr=sym_addr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WsLoopOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.wsloop"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,-1,-1,-1,0,]

  _ODS_REGIONS = (1, True)

  def __init__(self, lowerBound, upperBound, step, linear_vars, linear_step_vars, reduction_vars, *, reductions=None, schedule_val=None, schedule_chunk_var=None, schedule_modifier=None, simd_modifier=None, nowait=None, ordered_val=None, order_val=None, inclusive=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(lowerBound))
    operands.append(_get_op_results_or_values(upperBound))
    operands.append(_get_op_results_or_values(step))
    operands.append(_get_op_results_or_values(linear_vars))
    operands.append(_get_op_results_or_values(linear_step_vars))
    operands.append(_get_op_results_or_values(reduction_vars))
    operands.append(_get_op_result_or_value(schedule_chunk_var) if schedule_chunk_var is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if reductions is not None: attributes["reductions"] = (reductions if (
        issubclass(type(reductions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefArrayAttr')(reductions, context=_ods_context))
    if schedule_val is not None: attributes["schedule_val"] = (schedule_val if (
        issubclass(type(schedule_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ScheduleKindAttr')) else
          _ods_ir.AttrBuilder.get('ScheduleKindAttr')(schedule_val, context=_ods_context))
    if schedule_modifier is not None: attributes["schedule_modifier"] = (schedule_modifier if (
        issubclass(type(schedule_modifier), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ScheduleModifierAttr')) else
          _ods_ir.AttrBuilder.get('ScheduleModifierAttr')(schedule_modifier, context=_ods_context))
    if bool(simd_modifier): attributes["simd_modifier"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(nowait): attributes["nowait"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if ordered_val is not None: attributes["ordered_val"] = (ordered_val if (
        issubclass(type(ordered_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(ordered_val, context=_ods_context))
    if order_val is not None: attributes["order_val"] = (order_val if (
        issubclass(type(order_val), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('OrderKindAttr')) else
          _ods_ir.AttrBuilder.get('OrderKindAttr')(order_val, context=_ods_context))
    if bool(inclusive): attributes["inclusive"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lowerBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def upperBound(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def step(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def linear_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def linear_step_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range

  @builtins.property
  def reduction_vars(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range

  @builtins.property
  def schedule_chunk_var(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 6)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def reductions(self):
    if "reductions" not in self.operation.attributes:
      return None
    return self.operation.attributes["reductions"]

  @reductions.setter
  def reductions(self, value):
    if value is not None:
      self.operation.attributes["reductions"] = value
    elif "reductions" in self.operation.attributes:
      del self.operation.attributes["reductions"]

  @reductions.deleter
  def reductions(self):
    del self.operation.attributes["reductions"]

  @builtins.property
  def schedule_val(self):
    if "schedule_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["schedule_val"]

  @schedule_val.setter
  def schedule_val(self, value):
    if value is not None:
      self.operation.attributes["schedule_val"] = value
    elif "schedule_val" in self.operation.attributes:
      del self.operation.attributes["schedule_val"]

  @schedule_val.deleter
  def schedule_val(self):
    del self.operation.attributes["schedule_val"]

  @builtins.property
  def schedule_modifier(self):
    if "schedule_modifier" not in self.operation.attributes:
      return None
    return self.operation.attributes["schedule_modifier"]

  @schedule_modifier.setter
  def schedule_modifier(self, value):
    if value is not None:
      self.operation.attributes["schedule_modifier"] = value
    elif "schedule_modifier" in self.operation.attributes:
      del self.operation.attributes["schedule_modifier"]

  @schedule_modifier.deleter
  def schedule_modifier(self):
    del self.operation.attributes["schedule_modifier"]

  @builtins.property
  def simd_modifier(self):
    return "simd_modifier" in self.operation.attributes

  @simd_modifier.setter
  def simd_modifier(self, value):
    if bool(value):
      self.operation.attributes["simd_modifier"] = _ods_ir.UnitAttr.get()
    elif "simd_modifier" in self.operation.attributes:
      del self.operation.attributes["simd_modifier"]

  @simd_modifier.deleter
  def simd_modifier(self):
    del self.operation.attributes["simd_modifier"]

  @builtins.property
  def nowait(self):
    return "nowait" in self.operation.attributes

  @nowait.setter
  def nowait(self, value):
    if bool(value):
      self.operation.attributes["nowait"] = _ods_ir.UnitAttr.get()
    elif "nowait" in self.operation.attributes:
      del self.operation.attributes["nowait"]

  @nowait.deleter
  def nowait(self):
    del self.operation.attributes["nowait"]

  @builtins.property
  def ordered_val(self):
    if "ordered_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["ordered_val"]

  @ordered_val.setter
  def ordered_val(self, value):
    if value is not None:
      self.operation.attributes["ordered_val"] = value
    elif "ordered_val" in self.operation.attributes:
      del self.operation.attributes["ordered_val"]

  @ordered_val.deleter
  def ordered_val(self):
    del self.operation.attributes["ordered_val"]

  @builtins.property
  def order_val(self):
    if "order_val" not in self.operation.attributes:
      return None
    return self.operation.attributes["order_val"]

  @order_val.setter
  def order_val(self, value):
    if value is not None:
      self.operation.attributes["order_val"] = value
    elif "order_val" in self.operation.attributes:
      del self.operation.attributes["order_val"]

  @order_val.deleter
  def order_val(self):
    del self.operation.attributes["order_val"]

  @builtins.property
  def inclusive(self):
    return "inclusive" in self.operation.attributes

  @inclusive.setter
  def inclusive(self, value):
    if bool(value):
      self.operation.attributes["inclusive"] = _ods_ir.UnitAttr.get()
    elif "inclusive" in self.operation.attributes:
      del self.operation.attributes["inclusive"]

  @inclusive.deleter
  def inclusive(self):
    del self.operation.attributes["inclusive"]

  @builtins.property
  def region(self):
    return self.regions[0]

def wsloop(lower_bound, upper_bound, step, linear_vars, linear_step_vars, reduction_vars, *, reductions=None, schedule_val=None, schedule_chunk_var=None, schedule_modifier=None, simd_modifier=None, nowait=None, ordered_val=None, order_val=None, inclusive=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(WsLoopOp(lowerBound=lower_bound, upperBound=upper_bound, step=step, linear_vars=linear_vars, linear_step_vars=linear_step_vars, reduction_vars=reduction_vars, reductions=reductions, schedule_val=schedule_val, schedule_chunk_var=schedule_chunk_var, schedule_modifier=schedule_modifier, simd_modifier=simd_modifier, nowait=nowait, ordered_val=ordered_val, order_val=order_val, inclusive=inclusive, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "omp.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(results_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(YieldOp(results_=results_, loc=loc, ip=ip))
